<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>Asset</th>
                                    <th>Username</th>
                                    <th>Action</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Profit/Loss</th>  
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $userAssets->where('status', 'complete'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php
                                            $symbollowcase = strtolower($trade->assets);
                                            $icon = $trade->assets;
                                            $icon2 = strtolower(substr($trade->assets, 0, 2));
                                            $iconSrc = '';

                                            if ($trade->trade_type == 'Crypto') {
                                                $iconSrc = "https://raw.githubusercontent.com/spothq/cryptocurrency-icons/refs/heads/master/svg/color/{$symbollowcase}.svg";
                                            } elseif ($trade->trade_type == 'Stocks') {
                                                $iconSrc = "https://cdn.jsdelivr.net/gh/ahmeterenodaci/Nasdaq-Stock-Exchange-including-Symbols-and-Logos/logos/_{$icon}.png";
                                            } elseif ($trade->trade_type == 'Forex') {
                                                $iconSrc = "https://flagcdn.com/36x27/{$icon2}.png";
                                            }
                                        ?>
                                        <img src="<?php echo e($iconSrc); ?>" class="w-30 h-30 rounded-circle" alt="icon">
                                        <?php echo e($trade->assets); ?>

                                    </td>
                                    <td><?php echo e($trade->user_name); ?></td>
                                    <td><?php echo e($trade->action); ?></td>
                                    <td><?php echo e($trade->trade_type); ?></td>
                                    <td><?php echo e($trade->amount); ?></td>
                                    <td class="px--6 py--4">
                                        <span class="badge badge--success"><?php echo e($trade->profit); ?></span>
                                        <br>
                                        <span class="badge badge--danger"><?php echo e($trade->loss); ?></span>
                                    </td>
                                    <td>
                                        <?php if($trade->status == 'open'): ?>
                                            <span class="badge badge--success"><?php echo e($trade->status); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge--danger"><?php echo e($trade->status); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#updateModal<?php echo e($trade->id); ?>">
                                            Update
                                        </button>
                                    </td>
                                </tr>

                                <!-- Update Modal -->
                                <div class="modal fade" id="updateModal<?php echo e($trade->id); ?>" tabindex="-1" role="dialog" aria-labelledby="updateModalLabel<?php echo e($trade->id); ?>" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="updateModalLabel<?php echo e($trade->id); ?>">Update Trade for <?php echo e($trade->user_name); ?></h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="<?php echo e(route('admin.order.trade.update', $trade->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                 
                                               
    <div class="modal-body">
                                                    <div class="form-group">
                                                        <label for="amount">Amount</label>
                                                        <input type="text" class="form-control" id="amount" name="amount" value="<?php echo e($trade->amount); ?>">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="profit">Profit</label>
                                                        <input type="text" class="form-control" id="profit" name="profit" value="<?php echo e($trade->profit); ?>">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="loss">Loss</label>
                                                        <input type="text" class="form-control" id="loss" name="loss" value="<?php echo e($trade->loss); ?>">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="status">Status</label>
                                                        <select class="form-control" id="status" name="status">
                                                            <option value="open" <?php echo e($trade->status == 'open' ? 'selected' : ''); ?>>Open</option>
                                                            <option value="closed" <?php echo e($trade->status == 'closed' ? 'selected' : ''); ?>>Closed</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Save changes</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
    <script>
        "use strict";
        (function($) {
            $(`select[name=trade_side]`).on('change', function(e) {
                $(this).closest('form').submit();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vurapro/tradepro.vura.pro/core/resources/views/admin/order/trade_history.blade.php ENDPATH**/ ?>