

<?php $__env->startSection('content'); ?>
<main class="p-4 sm:px-6 flex-1 overflow-auto bg-white">
    <div class="grid grid-cols-1 lg:grid-cols-42 gap-6">
        <!-- Deposits Section -->
        <div class="p-6 bg-white rounded-xl shadow-md">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
                <h1 class="text-2xl font-bold text-gray-800">Deposits</h1>
                <button onclick="openModal()" class="bg-gradient-to-r from-indigo-600 to-blue-500 hover:from-indigo-700 hover:to-blue-600 px-5 py-2.5 rounded-lg text-white font-medium shadow-md transition-all">
                    Deposit now
                </button>
            </div>

            <!-- Responsive Table -->
            <div class="w-full overflow-x-auto rounded-lg border border-gray-100">
                <table class="min-w-full text-sm text-left text-black">
                    <thead class="bg-gray-50 text-gray-600 font-medium">
                        <tr>
                            <th class="px-4 py-3">Date</th>
                            <th class="px-4 py-3">Reference</th>
                            <th class="px-4 py-3">Method</th>
                            <th class="px-4 py-3">Type</th>
                            <th class="px-4 py-3">Amount</th>
                            <th class="px-4 py-3">In (USD)</th>
                            <th class="px-4 py-3">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php $__empty_1 = true; $__currentLoopData = $cryptoDeposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-4 py-3 text-black"><?php echo e($deposit->created_at->format('Y-m-d H:i')); ?></td>
                                <td class="px-4 py-3 text-black"><?php echo e($deposit->reference); ?></td>
                                <td class="px-4 py-3 text-black"><?php echo e($deposit->currency); ?></td>
                                <td class="px-4 py-3 text-black"><?php echo e($deposit->type); ?></td>
                                <td class="px-4 py-3 text-black"><?php echo e(number_format($deposit->amount, 2)); ?></td>
                                <td class="px-4 py-3 text-black" id="usd-amount-<?php echo e($deposit->id); ?>"></td>
                                <td class="px-4 py-3 text-black">
                                    <span class="px-3 py-1 rounded-full text-xs font-medium
                                        <?php if($deposit->status == 1): ?> bg-green-100 text-green-800
                                        <?php elseif($deposit->status == 2): ?> bg-amber-100 text-amber-800
                                        <?php elseif($deposit->status == 3): ?> bg-red-100 text-red-800
                                        <?php else: ?> bg-gray-100 text-gray-800
                                        <?php endif; ?>">
                                        <?php if($deposit->status == 0): ?> Initiated
                                        <?php elseif($deposit->status == 1): ?> Completed
                                        <?php elseif($deposit->status == 2): ?> Pending
                                        <?php elseif($deposit->status == 3): ?> Rejected
                                        <?php else: ?> Pending
                                        <?php endif; ?>
                                    </span>
                                </td>
                            </tr>
                            <script>
                                fetch(`https://min-api.cryptocompare.com/data/price?fsym=<?php echo e($deposit->currency); ?>&tsyms=USD&api_key=6994a7265d2d0ad7b35a3de4ff877b7c54d8e922f7c7c05141a4583ed300fcfd`)
                                    .then(response => response.json())
                                    .then(data => {
                                        const usdAmount = (<?php echo e($deposit->amount); ?> * data.USD).toFixed(2);
                                        document.getElementById('usd-amount-<?php echo e($deposit->id); ?>').textContent = `$${usdAmount}`;
                                    })
                                    .catch(error => console.error('Error fetching USD conversion:', error));
                            </script>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-6 text-gray-500">
                                    You have not made any deposits yet.
                                    <button onclick="openModal()" class="text-indigo-600 hover:text-indigo-800 hover:underline ml-1 font-medium">
                                        Click here to make a deposit.
                                    </button>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Deposit Modal -->
    <div id="depositModal" class="hidden fixed inset-0 bg-gray-900 bg-opacity-50 flex items-center justify-center z-50 p-4">
        <div class="bg-white rounded-xl shadow-xl w-full max-w-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-bold text-gray-800">Deposit</h2>
                <button id="closeModalButton" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            </div>

            <p class="text-gray-600 text-sm mb-6">
                Choose method, enter amount and upload payment proof to proceed.
            </p>

            <form action="<?php echo e(route('user.crypto.deposit.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" value="crypto">

                <div class="space-y-4">
                    <!-- Method -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Method:</label>
                        <select name="currency" id="cryptoMethod" class="w-full bg-gray-50 border border-gray-200 rounded-lg px-4 py-2.5 focus:ring-indigo-100 focus:border-indigo-500" required>
                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option 
                                    value="<?php echo e($currency->name); ?>"
                                    data-wallet="<?php echo e($currency->description); ?>"
                                    data-icon="https://raw.githubusercontent.com/spothq/cryptocurrency-icons/refs/heads/master/svg/color/<?php echo e(strtolower($currency->name)); ?>.svg"
                                >
                                    <?php echo e($currency->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Wallet -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Address:</label>
                        <div class="flex items-center space-x-2">
                            <input type="text" id="walletAddress" class="w-full bg-gray-50 border border-gray-200 rounded-lg px-4 py-2 text-sm" readonly>
                            <button type="button" id="copyAddressButton" class="text-gray-400 hover:text-indigo-600 transition">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M8 3a1 1 0 011-1h2a1 1 0 110 2H9a1 1 0 01-1-1z"/>
                                    <path d="M6 3a2 2 0 00-2 2v11a2 2 0 002 2h8a2 2 0 002-2V5a2 2 0 00-2-2 3 3 0 01-3 3H9a3 3 0 01-3-3z"/>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <!-- Amount -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Amount:</label>
                        <div class="flex items-center">
                            <input type="text" name="amount" value="0.00" required class="w-full bg-gray-50 border border-gray-200 rounded-l-lg px-4 py-2 text-gray-700">
                            <span id="cryptoIcon" class="bg-gray-100 border border-gray-200 rounded-r-lg px-4 py-2 text-gray-700 min-w-[70px] flex items-center justify-center"></span>
                        </div>
                    </div>

                    <!-- Payment Proof -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Payment Proof:</label>
                        <input type="file" name="proof" required class="w-full bg-gray-50 border border-gray-200 rounded-lg px-4 py-2">
                    </div>

                    <!-- Submit -->
                    <div class="pt-2">
                        <button type="submit" class="w-full bg-indigo-600 hover:bg-indigo-700 text-white py-2.5 rounded-lg font-medium transition">
                            Submit Deposit
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</main>

<script>
    // Toggle Modal
    function openModal() {
        document.getElementById('depositModal').classList.remove('hidden');
    }

    document.getElementById('closeModalButton')?.addEventListener('click', () => {
        document.getElementById('depositModal').classList.add('hidden');
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vurapro/tradepro.vura.pro/core/resources/views/templates/basic/user/crypto_deposit.blade.php ENDPATH**/ ?>