<?php $__env->startSection('content'); ?>
    <main class="p-2 sm:px-2 flex-1 overflow-auto">
        <div class="grid grid-cols-1 ld:grid-cols-2 gap-12">
            <div class="p-4 bg-black rounded-lg shadow">
                <div class="container mx-auto p-4">
                    <div class="mt-8">
                        <table class="min-w-full bg-black">
                            <thead>
                                <tr>
                                    <th class="py-2">ID</th>
                                    <th class="py-2">Currency</th>
                                    <th class="py-2">Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $symbollowcase = strtolower($wallet->currency);
                                    ?>
                                    <tr>
                                        <td class="border px-4 py-2"><?php echo e($wallet->id); ?></td>
                                        <td class="border px-4 py-2">
                                            <img src="https://raw.githubusercontent.com/spothq/cryptocurrency-icons/refs/heads/master/svg/color/<?php echo e($symbollowcase); ?>.svg" alt="<?php echo e($wallet->currency); ?>" class="inline-block h-6 w-6">
                                            <?php echo e($wallet->currency); ?>

                                        </td>
                                   
                                        <?php
                                            // Fetch the current price of the asset in USD
                                            $price = file_get_contents('https://min-api.cryptocompare.com/data/price?fsym=' . strtoupper($wallet->currency) . '&tsyms=USD');
                                            $price = json_decode($price, true)['USD'];
                                            $usdBalance = $wallet->balance * $price;
                                        ?>
                                        <td class="border px-4 py-2">
                                            <?php echo e(number_format($wallet->balance, 4)); ?> <?php echo e($wallet->currency); ?> <br>
                                            $ <?php echo e(number_format($usdBalance, 2)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\mrsam\core\resources\views/templates/basic/user/wallet/list.blade.php ENDPATH**/ ?>