<?php $__env->startSection('content'); ?>
<main class="p-2 sm:px-2 flex-1 overflow-auto">
    <div class="container mx-auto p-4">
        <!-- Header -->
        <div class="flex justify-between items-center mb-8">
            <h1 class="text-2xl font-bold text-white">Your Assets</h1>
        </div>

        <!-- Filter Section -->
        <div class="mb-8 bg-gray-800 p-4 rounded-lg">
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                <div class="w-full md:w-auto">
                    <label for="assetType" class="block text-sm font-medium text-gray-300 mb-1">Asset Type</label>
                    <select id="assetType" class="bg-gray-700 text-white rounded-lg p-2 w-full">
                        <option value="all">All Assets</option>
                        <option value="fiat">Fiat Currencies</option>
                        <option value="crypto">Cryptocurrencies</option>
                        <option value="stock">Stocks</option>
                    </select>
                </div>
                <div class="w-full md:w-auto">
                    <label for="searchAsset" class="block text-sm font-medium text-gray-300 mb-1">Search</label>
                    <input type="text" id="searchAsset" placeholder="Search assets..." class="bg-gray-700 text-white rounded-lg p-2 w-full">
                </div>
            </div>
        </div>

        <!-- Assets Table -->
        <div class="bg-gray-800 rounded-lg overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead class="bg-gray-700">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Asset</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Type</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Price (USD)</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Balance</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Value (USD)</th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-300 uppercase tracking-wider">Action</th>
                        </tr>
                    </thead>
                    <tbody id="assetsTableBody" class="bg-gray-800 divide-y divide-gray-700">
                        <!-- Loading state -->
                        <tr id="loadingRow">
                            <td colspan="6" class="px-6 py-4 text-center text-gray-400">
                                <div class="flex justify-center items-center">
                                    <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                    </svg>
                                    Loading assets...
                                </div>
                            </td>
                        </tr>
                        <!-- Error state (hidden by default) -->
                        <tr id="errorRow" class="hidden">
                            <td colspan="6" class="px-6 py-4 text-center text-red-500">
                                Failed to load assets. Please try again later.
                            </td>
                        </tr>
                        <!-- Empty state (hidden by default) -->
                        <tr id="emptyRow" class="hidden">
                            <td colspan="6" class="px-6 py-4 text-center text-gray-400">
                                No assets found matching your criteria.
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // DOM elements
        const assetTypeSelect = document.getElementById('assetType');
        const searchInput = document.getElementById('searchAsset');
        const assetsTableBody = document.getElementById('assetsTableBody');
        const loadingRow = document.getElementById('loadingRow');
        const errorRow = document.getElementById('errorRow');
        const emptyRow = document.getElementById('emptyRow');
        
        // Sample asset data (in a real app, this would come from an API)
        const assets = [
            // Fiat currencies
            { symbol: 'USD', name: 'US Dollar', type: 'fiat', price: 1.00, balance: 1500.50 },
            { symbol: 'EUR', name: 'Euro', type: 'fiat', price: 1.08, balance: 820.75 },
            { symbol: 'GBP', name: 'British Pound', type: 'fiat', price: 1.22, balance: 350.20 },
            { symbol: 'JPY', name: 'Japanese Yen', type: 'fiat', price: 0.0073, balance: 150000 },
            { symbol: 'AUD', name: 'Australian Dollar', type: 'fiat', price: 0.67, balance: 1200.00 },
            
            // Cryptocurrencies
            { symbol: 'BTC', name: 'Bitcoin', type: 'crypto', price: 42000.50, balance: 0.025 },
            { symbol: 'ETH', name: 'Ethereum', type: 'crypto', price: 2300.75, balance: 1.5 },
            { symbol: 'BNB', name: 'Binance Coin', type: 'crypto', price: 305.20, balance: 5.0 },
            { symbol: 'XRP', name: 'Ripple', type: 'crypto', price: 0.55, balance: 1500 },
            { symbol: 'SOL', name: 'Solana', type: 'crypto', price: 95.30, balance: 12.5 },
            
            // Stocks
            { symbol: 'AAPL', name: 'Apple Inc.', type: 'stock', price: 175.50, balance: 10 },
            { symbol: 'TSLA', name: 'Tesla Inc.', type: 'stock', price: 210.75, balance: 5 },
            { symbol: 'AMZN', name: 'Amazon.com Inc.', type: 'stock', price: 155.30, balance: 3 },
            { symbol: 'GOOGL', name: 'Alphabet Inc.', type: 'stock', price: 135.20, balance: 8 },
            { symbol: 'MSFT', name: 'Microsoft Corp.', type: 'stock', price: 305.45, balance: 6 }
        ];
        
        // Function to format numbers
        function formatNumber(num, decimals = 2) {
            return num.toLocaleString(undefined, {
                minimumFractionDigits: decimals,
                maximumFractionDigits: decimals
            });
        }
        
        // Function to render assets
        function renderAssets() {
            const typeFilter = assetTypeSelect.value;
            const searchQuery = searchInput.value.toLowerCase();
            
            // Filter assets
            let filteredAssets = assets.filter(asset => {
                const matchesType = typeFilter === 'all' || asset.type === typeFilter;
                const matchesSearch = asset.symbol.toLowerCase().includes(searchQuery) || 
                                    asset.name.toLowerCase().includes(searchQuery);
                return matchesType && matchesSearch;
            });
            
            // Clear table
            assetsTableBody.innerHTML = '';
            
            // Show empty state if no assets
            if (filteredAssets.length === 0) {
                emptyRow.classList.remove('hidden');
                assetsTableBody.appendChild(emptyRow);
                return;
            } else {
                emptyRow.classList.add('hidden');
            }
            
            // Add filtered assets to table
            filteredAssets.forEach(asset => {
                const valueUSD = asset.price * asset.balance;
                
                const row = document.createElement('tr');
                row.className = 'hover:bg-gray-700';
                row.innerHTML = `
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-10 w-10 bg-gray-600 rounded-full flex items-center justify-center">
                                <span class="text-white font-medium">${asset.symbol[0]}</span>
                            </div>
                            <div class="ml-4">
                                <div class="text-sm font-medium text-white">${asset.symbol}</div>
                                <div class="text-sm text-gray-400">${asset.name}</div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                            ${asset.type === 'fiat' ? 'bg-blue-100 text-blue-800' : 
                              asset.type === 'crypto' ? 'bg-purple-100 text-purple-800' : 
                              'bg-green-100 text-green-800'}">
                            ${asset.type.charAt(0).toUpperCase() + asset.type.slice(1)}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-white">
                        $${formatNumber(asset.price, asset.type === 'fiat' ? 4 : 2)}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-white">
                        ${formatNumber(asset.balance, asset.type === 'fiat' ? 2 : 
                                      asset.type === 'crypto' ? 6 : 2)} ${asset.symbol}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-white">
                        $${formatNumber(valueUSD)}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                        <a href="<?php echo e(route('trade.index')); ?>?asset=${asset.symbol}" class="text-blue-500 hover:text-blue-400 mr-4">Trade</a>
                        <a href="#" class="text-green-500 hover:text-green-400">Deposit</a>
                    </td>
                `;
                assetsTableBody.appendChild(row);
            });
        }
        
        // Simulate API loading (in a real app, you would fetch from an API)
        function loadAssets() {
            loadingRow.classList.remove('hidden');
            errorRow.classList.add('hidden');
            
            // Simulate network request delay
            setTimeout(() => {
                try {
                    // In a real app, you would fetch data here
                    // const response = await fetch('/api/assets');
                    // const data = await response.json();
                    
                    loadingRow.classList.add('hidden');
                    renderAssets();
                } catch (error) {
                    loadingRow.classList.add('hidden');
                    errorRow.classList.remove('hidden');
                    console.error('Error loading assets:', error);
                }
            }, 800);
        }
        
        // Event listeners
        assetTypeSelect.addEventListener('change', renderAssets);
        searchInput.addEventListener('input', renderAssets);
        
        // Initial load
        loadAssets();
        
        // In a real app, you might want to periodically update prices
        // setInterval(fetchLatestPrices, 60000); // Update every minute
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\mrsam\core\resources\views/templates/basic/user/market.blade.php ENDPATH**/ ?>