
<script src="https://cdn.tailwindcss.com"></script>
<?php $__env->startSection('content'); ?>
    <div class="container py-120 dark-bg">
        <div class="row justify-content-center bg-dark">
            <div class="col-md-8 col-lg-7 col-xl-6">
                <div class="card custom--card bg-dark">
                    <div class="card-header bg-black">
                        <h5 class="card-title"><?php echo e(__($pageTitle)); ?></h5>
                    </div>

                    <div class="card-body bg-black">
                        <form method="POST" action="<?php echo e(route('user.data.submit')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row bg-black ">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Username'); ?></label>
                                        <input type="text" class="form-control form--control checkUser" placeholder="<?php echo app('translator')->get('Username'); ?>" name="username" value="<?php echo e(old('username')); ?>" required>
                                        <small class="text-danger usernameExist"></small>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-md-12 col-sm-6">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Country'); ?></label>
                                        <div class="select2-wrapper">
                                            <select name="country" class="form--select form--control select2">
                                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option data-mobile_code="<?php echo e($country->dial_code); ?>" value="<?php echo e($country->country); ?>" data-code="<?php echo e($key); ?>">
                                                        <?php echo e(__($country->country)); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-md-12 col-sm-6">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Mobile'); ?></label>
                                        <div class="input-group custom-input-group">
                                            <span class="input-group-text mobile-code">
                                            </span>
                                            <input type="hidden" name="mobile_code">
                                            <input type="hidden" name="country_code">
                                            <input type="number" name="mobile" value="<?php echo e(old('mobile')); ?>" class="form-control form--control checkUser" required>
                                        </div>
                                        <small class="text-danger mobileExist"></small>
                                    </div>
                                </div>

                                <div style="display: none;">
                                    
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Address'); ?></label>
                                    <input type="text" class="form-control form--control" name="address" value="<?php echo e(old('address')); ?>">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('State'); ?></label>
                                    <input type="text" class="form-control form--control" name="state" value="<?php echo e(old('state')); ?>">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Zip Code'); ?></label>
                                    <input type="text" class="form-control form--control" name="zip" value="<?php echo e(old('zip')); ?>">
                                </div>

                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('City'); ?></label>
                                    <input type="text" class="form-control form--control" name="city" value="<?php echo e(old('city')); ?>">
                                </div>
                            </div>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="w-full bg-blue-600 text-white py-3 rounded-md hover:bg-blue-700 transition duration-300">
                                    <?php echo app('translator')->get('Submit'); ?>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            <?php if($mobileCode): ?>
                $(`option[data-code=<?php echo e($mobileCode); ?>]`).attr('selected', '');
            <?php endif; ?>


            $('select[name=country]').on('change', function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
                var value = $('[name=mobile]').val();
                var name = 'mobile';
                checkUser(value, name);
            });

            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));


            $('.checkUser').on('focusout', function(e) {
                var value = $(this).val();
                var name = $(this).attr('name')
                checkUser(value, name);
            });

            function checkUser(value, name) {
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var token = '<?php echo e(csrf_token()); ?>';

                if (name == 'mobile') {
                    var mobile = `${value}`;
                    var data = {
                        mobile: mobile,
                        mobile_code: $('.mobile-code').text().substr(1),
                        _token: token
                    }
                }
                if (name == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.field} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            }
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vurapro/tradepro.vura.pro/core/resources/views/templates/basic/user/user_data.blade.php ENDPATH**/ ?>