

<?php $__env->startSection('content'); ?>
<main class="p-2 sm:px-2 flex-1 overflow-auto bg-white text-black">
    <div class="grid grid-cols-1 ld:grid-cols-2 gap-12">
        <div class="p-4 rounded-lg shadow bg-white">
            <div class="container mx-auto p-4">

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Balance Section -->
                    <div class="bg-white rounded-lg p-6 border border-gray-200">
                        <div class="flex items-center space-x-2 mb-4">
                            <h2 class="text-black">Total Balance</h2>
                            <svg class="w-4 h-4 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z">
                                </path>
                            </svg>
                        </div>
                        <p class="text-3xl font-bold"><?php echo e(showAmount(auth()->user()->balance)); ?></p>
                    </div>

                    <!-- Recent Activity -->
                    <div class="bg-white rounded-lg p-6 border border-gray-200">
                        <h2 class="text-black mb-4">Recent Activity</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mt-4">
                            <?php $__currentLoopData = $topAssets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $symbollowcase = strtolower($asset->currency);
                                ?>
                                <div class="bg-white border border-gray-200 rounded-lg p-4">
                                    <img src="https://raw.githubusercontent.com/spothq/cryptocurrency-icons/refs/heads/master/svg/color/<?php echo e($symbollowcase); ?>.svg"
                                        alt="coin" class="w-5 h-5 mb-2">
                                    <h3 class="text-black"><?php echo e($asset->currency); ?></h3>
                                    <p class="text-black font-medium"><?php echo e(number_format($asset->amount, 0, '.', ',')); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <!-- Assets List -->
                <div class="mt-8">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-lg text-black">All your assets</h2>
                        <div class="relative">
                            <input type="text" placeholder="Search for assets"
                                class="bg-white border border-gray-300 rounded-lg pl-10 pr-4 py-2 w-64 focus:outline-none focus:ring-2 focus:ring-blue-500 text-black">
                            <svg class="w-5 h-5 absolute left-3 top-2.5 text-black" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z">
                                </path>
                            </svg>
                        </div>
                    </div>

                    <!-- Assets Table -->
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-300 bg-white text-black">
                            <thead class="bg-white">
                                <tr class="text-black text-left">
                                    <th class="py-3 px-4 border-b">Asset</th>
                                    <th class="py-3 px-4 border-b">Type</th>
                                    <th class="py-3 px-4 border-b">Current price (USD)</th>
                                    <th class="py-3 px-4 border-b">In your wallet</th>
                                    <th class="py-3 px-4 border-b">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $symbollowcase = strtolower($asset->currency);
                                        $price = 0;
                                        try {
                                            $res = @file_get_contents("https://min-api.cryptocompare.com/data/price?fsym=" . strtoupper($asset->currency) . "&tsyms=USD");
                                            $decoded = json_decode($res, true);
                                            $price = isset($decoded['USD']) ? $decoded['USD'] : 0;
                                        } catch (Exception $e) {
                                            $price = 0;
                                        }
                                    ?>
                                    <tr class="hover:bg-gray-100 transition duration-200 text-black">
                                        <td class="py-3 px-4 flex items-center space-x-2">
                                            <div class="w-8 h-8 bg-gray-100 rounded-full flex items-center justify-center">
                                                <img src="https://raw.githubusercontent.com/spothq/cryptocurrency-icons/refs/heads/master/svg/color/<?php echo e($symbollowcase); ?>.svg"
                                                    alt="coin" class="w-5 h-5">
                                            </div>
                                            <span><?php echo e($asset->currency); ?></span>
                                        </td>
                                        <td class="py-3 px-4"><?php echo e($asset->type); ?></td>
                                        <td class="py-3 px-4">
                                            $<?php echo e(number_format($price, 2)); ?>

                                            <?php if($price == 0): ?>
                                                <span class="text-xs text-red-500">(Unavailable)</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="py-3 px-4">
                                            <?php echo e($asset->amount); ?> <?php echo e($asset->currency); ?>

                                            (<?php echo e($price > 0 ? '$' . number_format($asset->amount * $price, 2) : 'Unavailable'); ?>)
                                        </td>
                                        <td class="py-3 px-4">
                                            <div class="flex space-x-2">
                                                <a href="<?php echo e(route('crypto.deposit.index')); ?>"
                                                    class="px-4 py-1 bg-blue-500 text-white rounded-lg hover:bg-blue-600 transition duration-200">
                                                    Deposit</a>
                                                <a href="<?php echo e(route('user.withdraw')); ?>"
                                                    class="px-4 py-1 bg-gray-300 text-black rounded-lg hover:bg-gray-400 transition duration-200">
                                                    Withdraw</a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</main>

<?php $__env->startPush('style'); ?>
<style>
    .tooltip {
        position: relative;
    }

    .tooltip:before {
        content: attr(data-tooltip);
        position: absolute;
        bottom: 100%;
        left: 50%;
        transform: translateX(-50%);
        padding: 4px 8px;
        background-color: rgba(0, 0, 0, 0.8);
        color: white;
        border-radius: 4px;
        font-size: 12px;
        white-space: nowrap;
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.2s, visibility 0.2s;
    }

    .tooltip:hover:before {
        opacity: 1;
        visibility: visible;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
// Optional: Add interactivity here if needed
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vurapro/tradepro.vura.pro/core/resources/views/templates/basic/user/user_assets.blade.php ENDPATH**/ ?>