<?php $__env->startSection('content'); ?>
    <div class="row justify-content-between align-items-center gy-4">
        <div class="col-lg-12">
            <div class="text-end">
                <a class="btn btn--sm btn--base outline" href="<?php echo e(route('user.plan.list')); ?>">
                    <i class="las la-store-alt"></i> <?php echo app('translator')->get('Buy Plan'); ?>
                </a>
            </div>
        </div>

        <div class="col-md-12">
            <div class="dashboard-card">
                <table class="table <?php echo e($histories->count() ? 'table--responsive--md' : 'table--empty'); ?>">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('SL'); ?></th>
                            <th><?php echo app('translator')->get('Name'); ?></th>
                            <th><?php echo app('translator')->get('Price'); ?></th>
                            <th><?php echo app('translator')->get('Funds'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Subscribed at'); ?></th>
                            <th><?php echo app('translator')->get('Expires at'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($histories->firstItem() + $loop->index); ?></td>
                                <td><span>
                                        <?php echo e($history->plan->name); ?> <?php if(auth()->user()->plan_history_id == $history->id): ?>
                                            <i class="fas text--success fa-circle" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Current Plan'); ?>"></i>
                                        <?php endif; ?>
                                    </span>
                                </td>
                                <td><?php echo e(showAmount($history->price)); ?></td>
                                <td><?php echo e(showAmount($history->fund)); ?></td>
                                <td><?php echo $history->statusBadge ?></td>
                                <td><?php echo e(showDateTime($history->created_at)); ?></td>
                                <td><?php echo e(showDateTime($history->expires_at)); ?></td>
                                <td>
                                    <?php if($history->expires_at > now() && $history->status == Status::PLAN_HISTORY_RUNNING): ?>
                                        <a href="<?php echo e(route('user.plan.buy', 0)); ?>" class="btn btn--base btn--sm"> <i class="la la-refresh"></i> <?php echo app('translator')->get('Renew'); ?></a>
                                    <?php else: ?>
                                        <a href="javascript:void(0)" class="btn btn--base btn--sm disabled"> <i class="la la-refresh"></i> <?php echo app('translator')->get('Renew'); ?></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo userTableEmptyMessage('plan history') ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($histories->hasPages()): ?>
                <?php echo e(paginateLinks($histories)); ?>

            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('select[name=gateway]').change(function() {

                if (!$('select[name=gateway]').val()) {
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                var resource = $('select[name=gateway] option:selected').data('gateway');


                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);
                var rate = parseFloat(1 / resource.currency_data.rate)
                if (resource.method.crypto == 1) {
                    var toFixedDigit = 8;
                    $('.crypto_currency').removeClass('d-none');
                } else {
                    var toFixedDigit = 2;
                    $('.crypto_currency').addClass('d-none');
                }
                $('.min').text(parseFloat(resource.min_amount).toFixed(2));
                $('.max').text(parseFloat(resource.max_amount).toFixed(2));
                var amount = parseFloat($('input[name=amount]').val());

                if (!amount) {
                    amount = 0;
                }
                if (amount <= 0) {
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                $('.preview-details').removeClass('d-none');
                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                $('.charge').text(charge);
                var payable = parseFloat((parseFloat(amount) + parseFloat(charge))).toFixed(2);
                $('.payable').text(payable);
                var final_amount = parseFloat((parseFloat((parseFloat(amount) + parseFloat(charge))) * rate).toFixed(toFixedDigit));
                $('.final_amount').text(final_amount);
                if (resource.currency != `<?php echo e(gs('cur_text')); ?>`) {
                    var rateElement = `<span class="fw-bold"><?php echo app('translator')->get('Conversion Rate'); ?></span> <span><span  class="fw-bold">1 <?php echo e(__(gs('cur_text'))); ?> = <span class="rate">${rate.toFixed(4)}</span>  <span class="method_currency">${resource.currency}</span></span></span>`;
                    $('.rate-element').html(rateElement)
                    $('.rate-element').removeClass('d-none');
                    $('.in-site-cur').removeClass('d-none');
                    $('.rate-element').addClass('d-flex');
                    $('.in-site-cur').addClass('d-flex');
                } else {
                    $('.rate-element').html('')
                    $('.rate-element').addClass('d-none');
                    $('.in-site-cur').addClass('d-none');
                    $('.rate-element').removeClass('d-flex');
                    $('.in-site-cur').removeClass('d-flex');
                }

                $('.method_currency').text(resource.currency);
                $('input[name=currency]').val(resource.currency);
                $('input[name=amount]').on('input');
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vurapro/tradepro.vura.pro/core/resources/views/templates/basic/user/plan/histories.blade.php ENDPATH**/ ?>