<?php $__env->startSection('content'); ?>
    <?php if($planHistory): ?>
        <div class="row gy-4">
            <div class="col-12">
                <div class="d-flex flex-wrap align-items-center justify-content-between gap-3">
                    <h5 class="mb-0"><?php echo e(__($planHistory->plan->name)); ?></h5>
                    <form class="max-w-content flex-grow-1">
                        <div class="select2-wrapper">
                            <select class="form--select form--control submit-form-on-change select2" name="plan_history"
                                data-minimum-results-for-search="-1">
                                <?php $__currentLoopData = $planHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleHistory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($singleHistory->id); ?>" <?php if(request()->plan_history == $singleHistory->id): echo 'selected'; endif; ?>>
                                        <?php echo e(__($singleHistory->plan->name)); ?>

                                        (<?php echo e(showDateTime($singleHistory->created_at, 'd-M-y')); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-12 col-xl-8">
                <div class="dashboard-card">
                    <table class="table table--responsive--md">
                        <thead>
                            <tr>
                                <th width="100px"><?php echo app('translator')->get('Phase No'); ?></th>
                                <th><?php echo app('translator')->get('Phase Name'); ?></th>
                                <th><?php echo app('translator')->get('Logic'); ?></th>
                                <th><?php echo app('translator')->get('Progress'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $planHistory->plan->planPhases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planPhase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $planPhase->phaseLogics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->parent->iteration); ?></td>
                                        <td><?php echo e(__($planPhase->name)); ?></td>
                                        <td class="text-wrap"><?php echo e(__($logic->logicBox->name)); ?></td>
                                        <td><?php echo getPhaseLogicProgress($planHistory, $logic); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-12 col-xl-4">
                <div class="dashboard-card">
                    <table class="table table--responsive--md">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Phase Name'); ?></th>
                                <th><?php echo app('translator')->get('Profit'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $planHistory->plan->planPhases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $planPhase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(__($planPhase->name)); ?></td>
                                    <td><?php echo e(getPhaseProfit($planHistory, $planPhase)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="<?php echo e(count($chart['date']) > 3 ? 'col-12' : 'col-xl-8'); ?>">
                <div class="dashboard-card">
                    <h5 class="dashboard-card__title"><?php echo app('translator')->get('Daily Profit Loss'); ?></h5>
                    <div id="plChartArea"> </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <?php if(count($planHistories)): ?>
            <div class="d-flex justify-content-end">
                <form>
                    <div class="select2-wrapper">
                        <select class="form--select form--control submit-form-on-change select2" name="plan_history"
                            data-minimum-results-for-search="-1">
                            <?php $__currentLoopData = $planHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleHistory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($singleHistory->id); ?>" <?php if(request()->plan_history): echo 'selected'; endif; ?>>
                                    <?php echo e(__($singleHistory->plan->name)); ?>

                                    (<?php echo e(showDateTime($singleHistory->created_at, 'd-M-y')); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </form>
            </div>
        <?php endif; ?>
        <div class="dashboard-card">
            <div class="transection__item justify-content-center p-5 skeleton">
                <div class="empty-thumb text-center">
                    <img src="<?php echo e(asset('assets/images/extra_images/empty.png')); ?>" />
                    <p class="fs-14"><?php echo app('translator')->get('No plan found'); ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php if($planHistory): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/vendor/apexcharts.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/global/js/vendor/chart.js.2.8.0.js')); ?>"></script>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('style'); ?>
        <style>
            .dashboard-card__title {
                border-bottom: 1px solid hsl(var(--white) / 0.12);
                padding-bottom: 16px;
                margin-bottom: 16px;
            }
            .select2-container .select2-selection--single .select2-selection__arrow {
                position: relative;
                top: 0;
                right: 0;
                transform: none;
            }

            .select2-container .select2-selection--single .select2-selection__rendered {
                padding: 0 !important;
            }

            .select2-container .select2-selection--single, 
            .select2-container .select2-selection--mutiple {
                display: flex;
                align-items: center;
                gap: 8px;
                padding: 20px 24px !important;
            }
        </style>
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('script'); ?>
        <script>
            (function($) {
                "use strict";

                var options = {
                    series: [{
                        name: 'Profit Loss',
                        data: <?php echo json_encode($chart['amount'], 15, 512) ?>
                    }],
                    chart: {
                        type: 'bar',
                        height: 650,
                        toolbar: {
                            show: false
                        }
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '50%',
                            endingShape: 'rounded',
                            colors: {
                                ranges: [{
                                        from: -Infinity,
                                        to: 0,
                                        color: '#fb4646'
                                    },
                                    {
                                        from: 0,
                                        to: Infinity,
                                        color: '#7ac851'
                                    }
                                ]
                            }
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    xaxis: {
                        categories: <?php echo json_encode($chart['date'], 15, 512) ?>,
                        labels: {
                            style: {
                                colors: '#FFFFFF',
                                fontSize: '14px'
                            }
                        }
                    },
                    yaxis: {
                        title: {
                            text: "<?php echo e(__(gs('cur_sym'))); ?>",
                        },
                        labels: {
                            formatter: function(value) {
                                return Math.round(value);
                            },
                            style: {
                                colors: '#FFFFFF',
                                fontSize: '14px'
                            }
                        }
                    },
                    grid: {
                        xaxis: {
                            lines: {
                                show: false
                            }
                        },
                        yaxis: {
                            lines: {
                                show: false
                            }
                        },
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        theme: 'dark',
                        y: {
                            formatter: function(val) {
                                return "<?php echo e(__(gs('cur_sym'))); ?>" + val + " "
                            }
                        }
                    }
                };
                var chart = new ApexCharts(document.querySelector("#plChartArea"), options);
                chart.render();

            })(jQuery);
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vurapro/tradepro.vura.pro/core/resources/views/templates/basic/user/plan/progress.blade.php ENDPATH**/ ?>