@extends($activeTemplate . 'layouts.master2')

@section('content')
<main class="p-4 sm:px-6 flex-1 overflow-auto bg-gray-50 text-gray-900">
    <!-- Hero Section -->
    <div class="bg-gradient-to-r from-indigo-600 to-blue-600 rounded-2xl p-8 mb-8 text-white flex flex-col md:flex-row items-center shadow-lg">
        <div class="md:w-3/5 mb-6 md:mb-0 md:pr-8">
            <h1 class="text-3xl font-bold mb-4">Copy Trading: How It Works</h1>
            <p class="text-lg mb-6 opacity-90">Replicate the trades of expert investors in real-time and leverage their expertise to potentially grow your portfolio while you learn from professionals.</p>
            <div class="flex flex-wrap gap-4">
                <a href="{{ route('copy.expert') }}" class="bg-white text-indigo-600 hover:bg-gray-100 px-6 py-3 rounded-lg font-semibold transition-colors duration-200 inline-flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                    </svg>
                    Browse Experts
                </a>
                <a href="#how-to-start" class="border border-white text-white hover:bg-white hover:text-indigo-600 px-6 py-3 rounded-lg font-semibold transition-colors duration-200">
                    Get Started
                </a>
            </div>
        </div>
        <div class="md:w-2/5">
            <img src="https://img.freepik.com/free-vector/finance-financial-performance-concept-illustration_53876-40450.jpg" alt="Copy Trading Illustration" class="rounded-xl shadow-md">
        </div>
    </div>

    <!-- Video Tutorials Section -->
    <div class="mb-12">
        <div class="text-center mb-8">
            <h2 class="text-2xl font-bold text-gray-800 mb-2">Video Tutorials</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">Watch these quick video guides to understand how copy trading works and how to make the most of this powerful feature.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- Video 1 -->
            <div class="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
                <div class="aspect-w-16 aspect-h-9 bg-gray-100">
                    <div class="w-full h-48 bg-gray-100 flex items-center justify-center">
                        <!-- Video embed would go here -->
                        <div class="text-center p-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-indigo-500 mx-auto mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <p>Video Placeholder</p>
                        </div>
                    </div>
                </div>
                <div class="p-5">
                    <h3 class="font-bold text-lg mb-2">Getting Started with Copy Trading</h3>
                    <p class="text-gray-600 text-sm mb-3">Learn the basics of copy trading, how to choose experts, and set up your first copy relationship.</p>
                    <span class="text-xs font-medium text-indigo-600 bg-indigo-50 rounded-full py-1 px-2">5:32 mins</span>
                </div>
            </div>

            <!-- Video 2 -->
            <div class="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
                <div class="aspect-w-16 aspect-h-9 bg-gray-100">
                    <div class="w-full h-48 bg-gray-100 flex items-center justify-center">
                        <!-- Video embed would go here -->
                        <div class="text-center p-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-indigo-500 mx-auto mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <p>Video Placeholder</p>
                        </div>
                    </div>
                </div>
                <div class="p-5">
                    <h3 class="font-bold text-lg mb-2">Advanced Copy Trading Strategies</h3>
                    <p class="text-gray-600 text-sm mb-3">Discover risk management techniques and how to diversify your copy trading portfolio effectively.</p>
                    <span class="text-xs font-medium text-indigo-600 bg-indigo-50 rounded-full py-1 px-2">7:15 mins</span>
                </div>
            </div>

            <!-- Video 3 -->
            <div class="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
                <div class="aspect-w-16 aspect-h-9 bg-gray-100">
                    <div class="w-full h-48 bg-gray-100 flex items-center justify-center">
                        <!-- Video embed would go here -->
                        <div class="text-center p-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-indigo-500 mx-auto mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <p>Video Placeholder</p>
                        </div>
                    </div>
                </div>
                <div class="p-5">
                    <h3 class="font-bold text-lg mb-2">Monitoring & Optimizing Performance</h3>
                    <p class="text-gray-600 text-sm mb-3">Learn how to track performance, when to stick with an expert, and when it might be time to make changes.</p>
                    <span class="text-xs font-medium text-indigo-600 bg-indigo-50 rounded-full py-1 px-2">6:48 mins</span>
                </div>
            </div>
        </div>
    </div>

    <!-- How It Works Steps -->
    <div id="how-to-start" class="mb-12 scroll-mt-16">
        <div class="text-center mb-8">
            <h2 class="text-2xl font-bold text-gray-800 mb-2">Step-By-Step Guide</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">Follow these simple steps to start copy trading and potentially grow your portfolio alongside expert traders.</p>
        </div>

        <div class="relative">
            <!-- Timeline Line -->
            <div class="absolute left-0 md:left-1/2 h-full w-0.5 bg-indigo-100 transform -translate-x-1/2 hidden md:block"></div>

            <!-- Step 1 -->
            <div class="flex flex-col md:flex-row mb-8 md:mb-12 relative">
                <div class="md:w-1/2 md:pr-8 md:text-right mb-4 md:mb-0">
                    <div class="bg-white p-5 rounded-xl shadow-sm border border-gray-100">
                        <span class="inline-block bg-indigo-600 text-white text-xl font-bold rounded-full w-10 h-10 flex items-center justify-center mb-3">1</span>
                        <h3 class="text-xl font-bold text-gray-800 mb-2">Access the Copy Trading Platform</h3>
                        <p class="text-gray-600">Start by navigating to the Copy Trading section from your dashboard. Ensure your account is properly set up with sufficient funds.</p>
                    </div>
                </div>
                <div class="md:w-1/2 flex justify-center items-center relative">
                    <div class="hidden md:block absolute left-0 transform -translate-x-1/2 bg-white border-4 border-indigo-600 rounded-full w-5 h-5 z-10"></div>
                    <div class="md:pl-8">
                        <img src="https://img.freepik.com/free-vector/dashboard-concept-illustration_114360-4744.jpg" alt="Dashboard Access" class="rounded-lg shadow-md max-w-xs mx-auto hidden md:block">
                    </div>
                </div>
            </div>

            <!-- Step 2 -->
            <div class="flex flex-col md:flex-row-reverse mb-8 md:mb-12 relative">
                <div class="md:w-1/2 md:pl-8 md:text-left mb-4 md:mb-0">
                    <div class="bg-white p-5 rounded-xl shadow-sm border border-gray-100">
                        <span class="inline-block bg-indigo-600 text-white text-xl font-bold rounded-full w-10 h-10 flex items-center justify-center mb-3">2</span>
                        <h3 class="text-xl font-bold text-gray-800 mb-2">Browse & Research Expert Traders</h3>
                        <p class="text-gray-600">Compare performance metrics, win rates, and trading strategies of various experts. Look for consistent performance that aligns with your risk tolerance.</p>
                    </div>
                </div>
                <div class="md:w-1/2 flex justify-center items-center relative">
                    <div class="hidden md:block absolute right-0 transform translate-x-1/2 bg-white border-4 border-indigo-600 rounded-full w-5 h-5 z-10"></div>
                    <div class="md:pr-8">
                        <img src="https://img.freepik.com/free-vector/financial-data-concept-illustration_114360-505.jpg" alt="Research Experts" class="rounded-lg shadow-md max-w-xs mx-auto hidden md:block">
                    </div>
                </div>
            </div>

            <!-- Step 3 -->
            <div class="flex flex-col md:flex-row mb-8 md:mb-12 relative">
                <div class="md:w-1/2 md:pr-8 md:text-right mb-4 md:mb-0">
                    <div class="bg-white p-5 rounded-xl shadow-sm border border-gray-100">
                        <span class="inline-block bg-indigo-600 text-white text-xl font-bold rounded-full w-10 h-10 flex items-center justify-center mb-3">3</span>
                        <h3 class="text-xl font-bold text-gray-800 mb-2">Select an Expert & Configure Settings</h3>
                        <p class="text-gray-600">Choose the expert(s) you want to copy and set your copy trading parameters including investment amount and risk level.</p>
                    </div>
                </div>
                <div class="md:w-1/2 flex justify-center items-center relative">
                    <div class="hidden md:block absolute left-0 transform -translate-x-1/2 bg-white border-4 border-indigo-600 rounded-full w-5 h-5 z-10"></div>
                    <div class="md:pl-8">
                        <img src="https://img.freepik.com/free-vector/terms-conditions-concept-illustration_114360-5391.jpg" alt="Configure Settings" class="rounded-lg shadow-md max-w-xs mx-auto hidden md:block">
                    </div>
                </div>
            </div>

            <!-- Step 4 -->
            <div class="flex flex-col md:flex-row-reverse mb-8 md:mb-12 relative">
                <div class="md:w-1/2 md:pl-8 md:text-left mb-4 md:mb-0">
                    <div class="bg-white p-5 rounded-xl shadow-sm border border-gray-100">
                        <span class="inline-block bg-indigo-600 text-white text-xl font-bold rounded-full w-10 h-10 flex items-center justify-center mb-3">4</span>
                        <h3 class="text-xl font-bold text-gray-800 mb-2">Activate Copy Trading</h3>
                        <p class="text-gray-600">Confirm your selection and activate the copy trading relationship. Your account will now automatically mirror the trades of your selected expert(s).</p>
                    </div>
                </div>
                <div class="md:w-1/2 flex justify-center items-center relative">
                    <div class="hidden md:block absolute right-0 transform translate-x-1/2 bg-white border-4 border-indigo-600 rounded-full w-5 h-5 z-10"></div>
                    <div class="md:pr-8">
                        <img src="https://img.freepik.com/free-vector/mobile-trading-abstract-concept-illustration_335657-3888.jpg" alt="Activate Copy Trading" class="rounded-lg shadow-md max-w-xs mx-auto hidden md:block">
                    </div>
                </div>
            </div>

            <!-- Step 5 -->
            <div class="flex flex-col md:flex-row relative">
                <div class="md:w-1/2 md:pr-8 md:text-right">
                    <div class="bg-white p-5 rounded-xl shadow-sm border border-gray-100">
                        <span class="inline-block bg-indigo-600 text-white text-xl font-bold rounded-full w-10 h-10 flex items-center justify-center mb-3">5</span>
                        <h3 class="text-xl font-bold text-gray-800 mb-2">Monitor & Adjust As Needed</h3>
                        <p class="text-gray-600">Track performance through your dashboard, review regular reports, and make adjustments to your copy trading strategy when necessary.</p>
                    </div>
                </div>
                <div class="md:w-1/2 flex justify-center items-center relative">
                    <div class="hidden md:block absolute left-0 transform -translate-x-1/2 bg-white border-4 border-indigo-600 rounded-full w-5 h-5 z-10"></div>
                    <div class="md:pl-8">
                        <img src="https://img.freepik.com/free-vector/data-inform-illustration-concept_114360-864.jpg" alt="Monitor Performance" class="rounded-lg shadow-md max-w-xs mx-auto hidden md:block">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Benefits Section -->
    <div class="mb-12">
        <div class="text-center mb-8">
            <h2 class="text-2xl font-bold text-gray-800 mb-2">Benefits of Copy Trading</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">Discover why thousands of traders are using our copy trading platform to enhance their trading experience.</p>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Benefit 1 -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                <div class="bg-indigo-100 p-3 rounded-full w-14 h-14 flex items-center justify-center mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <h3 class="font-bold text-lg mb-2 text-gray-800">Save Time</h3>
                <p class="text-gray-600 text-sm">Leverage experts' knowledge without spending hours analyzing markets and making trading decisions.</p>
            </div>

            <!-- Benefit 2 -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                <div class="bg-indigo-100 p-3 rounded-full w-14 h-14 flex items-center justify-center mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z" />
                    </svg>
                </div>
                <h3 class="font-bold text-lg mb-2 text-gray-800">Learn & Improve</h3>
                <p class="text-gray-600 text-sm">Study successful strategies in real-time by observing expert traders' decisions and market approach.</p>
            </div>

            <!-- Benefit 3 -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                <div class="bg-indigo-100 p-3 rounded-full w-14 h-14 flex items-center justify-center mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                    </svg>
                </div>
                <h3 class="font-bold text-lg mb-2 text-gray-800">Risk Management</h3>
                <p class="text-gray-600 text-sm">Set limits and controls to manage your exposure while benefiting from experts' trading knowledge.</p>
            </div>

            <!-- Benefit 4 -->
            <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                <div class="bg-indigo-100 p-3 rounded-full w-14 h-14 flex items-center justify-center mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                </div>
                <h3 class="font-bold text-lg mb-2 text-gray-800">Community</h3>
                <p class="text-gray-600 text-sm">Join a network of traders sharing insights, strategies, and market analysis to enhance your trading knowledge.</p>
            </div>
        </div>
    </div>

    <!-- FAQ Section -->
    <div class="mb-12">
        <div class="text-center mb-8">
            <h2 class="text-2xl font-bold text-gray-800 mb-2">Frequently Asked Questions</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">Find answers to common questions about our copy trading platform.</p>
        </div>

        <div class="max-w-3xl mx-auto">
            <div class="space-y-4">
                <!-- FAQ Item 1 -->
                <div class="border border-gray-200 rounded-xl overflow-hidden">
                    <button class="flex justify-between items-center w-full p-5 text-left bg-white hover:bg-gray-50 transition-colors">
                        <span class="font-medium text-gray-900">How much money do I need to start copy trading?</span>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    <div class="p-5 border-t border-gray-100 bg-gray-50">
                        <p class="text-gray-600">You can start copy trading with as little as $100, though we recommend at least $500 to ensure proper diversification and risk management. The specific minimum may vary depending on the expert trader you choose to copy.</p>
                    </div>
                </div>

                <!-- FAQ Item 2 -->
                <div class="border border-gray-200 rounded-xl overflow-hidden">
                    <button class="flex justify-between items-center w-full p-5 text-left bg-white hover:bg-gray-50 transition-colors">
                        <span class="font-medium text-gray-900">Can I copy multiple experts simultaneously?</span>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    <div class="p-5 border-t border-gray-100 bg-gray-50">
                        <p class="text-gray-600">Yes, you can copy multiple expert traders simultaneously. This can help diversify your trading strategy across different assets and trading styles. Just ensure you allocate your funds appropriately between them.</p>
                    </div>
                </div>

                <!-- FAQ Item 3 -->
                <div class="border border-gray-200 rounded-xl overflow-hidden">
                    <button class="flex justify-between items-center w-full p-5 text-left bg-white hover:bg-gray-50 transition-colors">
                        <span class="font-medium text-gray-900">How quickly are expert trades copied to my account?</span>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    <div class="p-5 border-t border-gray-100 bg-gray-50">
                        <p class="text-gray-600">Our platform executes copied trades in real-time with minimal delay, typically within milliseconds. However, market conditions, liquidity, and your broker's execution speed may affect the exact timing of trade execution.</p>
                    </div>
                </div>

                <!-- FAQ Item 4 -->
                <div class="border border-gray-200 rounded-xl overflow-hidden">
                    <button class="flex justify-between items-center w-full p-5 text-left bg-white hover:bg-gray-50 transition-colors">
                        <span class="font-medium text-gray-900">Can I stop copying an expert at any time?</span>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    <div class="p-5 border-t border-gray-100 bg-gray-50">
                        <p class="text-gray-600">Yes, you can stop copying an expert at any time. When you stop copying, you can choose to close all open positions immediately or let them run until you manually close them or they reach their stop loss/take profit levels.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="bg-white rounded-2xl shadow-sm p-8 border border-gray-100">
        <div class="text-center max-w-2xl mx-auto">
            <h2 class="text-2xl font-bold text-gray-800 mb-3">Ready to Start Copy Trading?</h2>
            <p class="text-gray-600 mb-6">Join thousands of traders already growing their portfolios with our expert copy trading platform.</p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="{{ route('copy.expert') }}" class="px-8 py-3 bg-indigo-600 hover:bg-indigo-700 text-white font-semibold rounded-lg transition-colors duration-200">
                    Browse Experts Now
                </a>
                <a href="{{ route('user.home') }}" class="px-8 py-3 border border-gray-300 hover:bg-gray-50 text-gray-700 font-semibold rounded-lg transition-colors duration-200">
                    Back to Dashboard
                </a>
            </div>
        </div>
    </div>
</main>

@push('style')
<style>
    /* Smooth scroll behavior */
    html {
        scroll-behavior: smooth;
    }
    
    /* For the FAQ accordion functionality */
    .faq-content {
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.3s ease;
    }
    
    .faq-toggle:checked + .faq-content {
        max-height: 1000px;
    }
    
    /* Image aspect ratio container */
    .aspect-w-16 {
        position: relative;
        padding-bottom: 56.25%;
    }
    
    .aspect-h-9 {
        position: absolute;
        height: 100%;
        width: 100%;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
    }
</style>
@endpush

@push('script')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // FAQ accordion functionality
        const faqButtons = document.querySelectorAll('.faq-button');
        
        faqButtons.forEach(button => {
            button.addEventListener('click', () => {
                const content = button.nextElementSibling;
                
                if (content.style.maxHeight) {
                    content.style.maxHeight = null;
                } else {
                    content.style.maxHeight = content.scrollHeight + 'px';
                }
                
                // Toggle the icon
                const icon = button.querySelector('svg');
                icon.classList.toggle('rotate-180');
            });
        });
    });
</script>
@endpush
@endsection
