<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ContainerAnalysis;

class GrafeasV1beta1PackageDetails extends \Google\Model
{
  protected $installationType = Installation::class;
  protected $installationDataType = '';

  /**
   * @param Installation
   */
  public function setInstallation(Installation $installation)
  {
    $this->installation = $installation;
  }
  /**
   * @return Installation
   */
  public function getInstallation()
  {
    return $this->installation;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GrafeasV1beta1PackageDetails::class, 'Google_Service_ContainerAnalysis_GrafeasV1beta1PackageDetails');
