
<?php
    $kyc = getContent('kyc.content', true);
?>

<style>
    .right-modal {
        transform: translateX(100%);
        transition: transform 0.3s ease-in-out;
    }
    .right-modal.open {
        transform: translateX(0);
    }
</style>
<?php $__env->startSection('content'); ?>
<main class="p-2 sm:px-2 flex-1 overflow-auto">

    <h1 class="text-white text-xl mb-4">Pools</h1>
    <div class="mb-6">
    <button onclick="openRightModal()" class="w-full bg-gray-700 text-white py-2 rounded-lg hover:bg-gray-600 transition-colors">
        Your Stakings
    </button>
    </div>
    <div class="grid md:grid-cols-2 gap-6">
        <?php $__currentLoopData = $stakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-gray-900 rounded-lg p-6">
            <div class="flex items-center gap-3 mb-6">
                <div class="w-8 h-8 rounded-full bg-gray-800 flex items-center justify-center">
                    <img src="https://raw.githubusercontent.com/spothq/cryptocurrency-icons/refs/heads/master/svg/color/<?php echo e(strtolower($stake->crypto_type)); ?>.svg" alt="<?php echo e($stake->crypto_type); ?>" class="w-10 h-10" />
                </div>
                <div>
                    <h2 class="text-white"><?php echo e($stake->name); ?></h2>
                    <p class="text-gray-500"><?php echo e($stake->crypto_type); ?></p>
                </div>
            </div>

            <div class="space-y-4">
                <div class="flex justify-between">
                    <span class="text-gray-500">Minimum</span>
                    <span class="text-white"><?php echo e($stake->minimum); ?> <?php echo e($stake->crypto_type); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Maximum</span>
                    <span class="text-white"><?php echo e($stake->maximum); ?> <?php echo e($stake->crypto_type); ?></span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-500">Cycle</span>
                    <span class="text-white"><?php echo e($stake->duration); ?></span>
                </div>
                <button 
                    onclick="openModal('<?php echo e($stake->crypto_type); ?>', '<?php echo e($stake->roi); ?>', '<?php echo e($stake->duration); ?>')"
                    class="w-full bg-blue-500 text-white py-2 rounded-lg hover:bg-blue-600 transition-colors">
                    Stake
                </button>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Staking Modal -->
    <div id="stakeModal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center">
        <div class="bg-gray-900 p-6 rounded-lg w-full max-w-md">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-lg text-white">Stake <span id="selectedCrypto">AVAX</span></h3>
                <button onclick="closeModal()" class="text-gray-500 hover:text-white text-xl">&times;</button>
            </div>

            <form action="<?php echo e(route('user.staking.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="crypto_type" id="cryptoTypeInput">
                <input type="hidden" name="duration" id="durationInput">

                <div class="space-y-4">
                    <div>
                        <label class="block text-gray-500 mb-2">Amount:</label>
                        <div class="flex gap-2">
                            <input type="number" name="amount" id="stakeAmount" class="flex-1 bg-gray-800 rounded px-3 py-2 text-white" />
                            <span class="text-white flex items-center" id="cryptoSymbol">AVAX</span>
                        </div>
                    </div>

                    <div>
                        <label class="block text-gray-500 mb-2">Current <span id="currentCrypto">AVAX</span> balance:</label>
                        <p class="text-white">0 <span id="balanceCrypto">AVAX</span></p>
                    </div>
 
                    <div>
                        <label class="block text-gray-500 mb-2">Duration:</label>
                        <select name="duration" class="w-full bg-gray-800 rounded px-3 py-2 text-white">
                            <?php for($i = 1; $i <= 30; $i++): ?>
                                <option value="<?php echo e($i); ?>"><?php echo e($i); ?> days</option>
                            <?php endfor; ?>
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-500 mb-2">ROI:</label>
                        <div class="flex gap-2">
                            <input type="disabled" name="roi" id="roi" class="flex-1 bg-gray-800 rounded px-3 py-2 text-white" />
                            <span class="text-white flex items-center">%</span>
                        </div>
                    </div>

                    <button type="submit" class="w-full bg-gray-700 text-white py-2 rounded-lg hover:bg-gray-600 transition-colors">
                        Stake
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- User Stakings Button -->
 

    <!-- Right Side Modal -->
    <div id="rightModal" class="right-modal fixed inset-y-0 right-0 bg-gray-900 w-80 p-6 overflow-auto">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-lg text-white">Your Stakings</h3>
            <button onclick="closeRightModal()" class="text-gray-500 hover:text-white text-xl">&times;</button>
        </div>
        
        <div class="space-y-4">
            <?php if($getUserStakes->isEmpty()): ?>
                <p class="text-gray-500">No records found.</p>
            <?php else: ?>
                <?php $__currentLoopData = $getUserStakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $getUserStake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-gray-800 rounded-lg p-4">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="w-8 h-8 rounded-full bg-gray-700 flex items-center justify-center">
                            <img src="https://raw.githubusercontent.com/spothq/cryptocurrency-icons/refs/heads/master/svg/color/<?php echo e(strtolower($getUserStake->crypto_type)); ?>.svg" alt="<?php echo e($getUserStake->crypto_type); ?>" class="w-10 h-10" />
                        </div>
                        <div>
                            <h2 class="text-white"><?php echo e($getUserStake->name); ?></h2>
                            <p class="text-gray-500"><?php echo e($getUserStake->crypto_type); ?></p>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <div class="flex justify-between">
                            <span class="text-gray-500">Amount</span>
                            <span class="text-white"><?php echo e($getUserStake->amount); ?> <?php echo e($getUserStake->crypto_type); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-500">Duration</span>
                            <span class="text-white"><?php echo e($getUserStake->duration); ?> days</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-500">ROI</span>
                            <span class="text-white"><?php echo e($getUserStake->roi); ?>%</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-500">Daily Profit</span>
                            <span class="text-white"><?php echo e(number_format((floatval($getUserStake->amount) * floatval($getUserStake->roi) / 100) / floatval($getUserStake->duration), 2)); ?> <?php echo e($getUserStake->crypto_type); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-500">Total Profit</span>
                            <span class="text-white"><?php echo e(number_format(floatval($getUserStake->amount) * floatval($getUserStake->roi) / 100, 2)); ?> <?php echo e($getUserStake->crypto_type); ?></span>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
    </div>

</main>
<script>
    function openModal(crypto, roi, duration) {
        document.getElementById('stakeModal').classList.remove('hidden');
        document.getElementById('selectedCrypto').textContent = crypto;
        document.getElementById('cryptoTypeInput').value = crypto;
        document.getElementById('durationInput').value = duration;
        document.getElementById('roi').value = roi;
    }

    function closeModal() {
        document.getElementById('stakeModal').classList.add('hidden');
    }

    function openRightModal() {
        document.getElementById('rightModal').classList.add('open');
    }

    function closeRightModal() {
        document.getElementById('rightModal').classList.remove('open');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/ojex/core/resources/views/templates/basic/user/staking.blade.php ENDPATH**/ ?>